



import cv2

import pytesseract
from PIL import Image
from gtts import gTTS
import os
import subprocess
from textblob import TextBlob

# Kameradan görüntü al
def capture_image():
    # Kamera objesini oluştur
    camera = cv2.VideoCapture(0)
    # Görüntüyü al
    ret, image = camera.read()
    if not ret:
        raise Exception("Kamera görüntü alınamadı.")
    # Kamera objesini kapat
    camera.release()
    return image

# Görüntüden metni çıkarma
def extract_text_from_image(image):
    # Görüntüyü Pillow formatına dönüştür
    pil_image = Image.fromarray(image)
    # Metni çıkart (Türkçe dilini kullanarak)
    text = pytesseract.image_to_string(pil_image, lang='tur')
    return text

# Türkçe yazım denetimi
def turkish_spell_check(text):
    blob = TextBlob(text)
    corrected_text = ""
    for sentence in blob.sentences:
        corrected_text += str(sentence.correct()) + " "
    return corrected_text

# Sesli okuma
def speak_text(text):
    # Türkçe seslendirme yapmak için 'tr' parametresini ekleyin
    tts = gTTS(text=text, lang='tr')
    # Ses dosyasını kaydet
    tts.save("output.mp3")
    # Ses dosyasını oynat
    os.system("afplay output.mp3")  # Mac için

# Ana fonksiyon
def main():
    try:
        # Görüntüyü kameradan al
        image = capture_image()sxczvxvsc
        # Metni çıkart
        extracted_text = extract_text_from_image(image)
        print("Çıkarılan Metin:", extracted_text)
            print("Metin çıkarılamadı. Okuma yapılamıyor.")
    except Exception as e:
        print("HATA:", e)
if __name__ == "__main__":
    main()c
